/*
 * @(#)RERFactory.java  1.0  2006-01-18
 *
 * Copyright (c) 2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.rer;

import ch.hslu.cm.rer.diagram.EntityFigure;
import ch.hslu.cm.rer.diagram.RERAttributeConnector;
import ch.hslu.cm.rer.diagram.RelationalERDiagram;
import ch.hslu.cm.rer.diagram.RelationshipFigure;
import ch.hslu.cm.rer.model.Entity;
import ch.hslu.cm.rer.model.RERAttribute;
import ch.hslu.cm.rer.model.RelationalERModel;
import ch.hslu.cm.rer.model.Relationship;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.StickyRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.liner.ElbowLiner;
import org.jhotdraw.draw.liner.SlantedLiner;
import org.jhotdraw.draw.locator.BezierLabelLocator;
import org.jhotdraw.xml.DefaultDOMFactory;
/**
 * RERFactory.
 * 
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 2006-01-18 Created.
 */
public class RERFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        // Old names for backwards compatibility
        { RelationalERModel.class, "RERM" },
        { RelationalERModel.class, "RelationalEntityRelationshipModel" },
        { RERAttribute.class, "attr" },
        { Relationship.class, "rel" },
        { Entity.class, "entity" },

        { RelationalERDiagram.class, "RERD" },
        { RelationalERDiagram.class, "RelationalEntityRelationshipDiagram" },
        { RelationshipFigure.class, "relF" },
        { EntityFigure.class, "entityF" },
        { TextFigure.class, "textF" },
        { GroupFigure.class, "g" },
        { TextAreaFigure.class, "ta" },
        
        { RERAttributeConnector.class, "attrConnector" },
        { StickyRectangleConnector.class, "arectConnector" },
        { ChopRectangleConnector.class, "rectConnector" },
        { BezierLabelLocator.class, "polylabelLocator" },
        { SlantedLiner.class, "slantedLiner" },
        { ArrowTip.class, "arrowTip" },
        { StickyRectangleConnector.class, "StickyChopConnector" },
        { ChopRectangleConnector.class, "ChopBoxConnector" },
        
        // New names
        { RelationalERModel.class, "RelationalERModel" },
        { RERAttribute.class, "Attribute" },
        { Relationship.class, "Relationship" },
        { Entity.class, "Entity" },

        { RelationalERDiagram.class, "RelationalERDiagram" },
        { RelationshipFigure.class, "RelationshipFigure" },
        { EntityFigure.class, "EntityFigure" },
        { TextFigure.class, "TextFigure" },
        { GroupFigure.class, "GroupFigure" },
        { TextAreaFigure.class, "TextAreaFigure" },
        
        { RERAttributeConnector.class, "AttributeConnector" },
        { StickyRectangleConnector.class, "StickyRectangleConnector" },
        { ChopRectangleConnector.class, "ChopRectangleConnector" },
        { BezierLabelLocator.class, "BezierLabelLocator" },
        { ElbowLiner.class, "ElbowLiner" },
        { SlantedLiner.class, "SlantedLiner" },
        { ArrowTip.class, "ArrowTip" }
    };
    private final static Object[][] enumTagArray = {
        { AttributeKeys.StrokePlacement.class, "strokePlacement" },
        { AttributeKeys.StrokeType.class, "strokeType" },
        { AttributeKeys.Underfill.class, "underfill" },
        { AttributeKeys.Orientation.class, "orientation" },
    };
    
    
    /** Creates a new instance. */
    public RERFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
        for (Object[] o : enumTagArray) {
            addEnumClass((String) o[1], (Class) o[0]);
        }
    }
}
